<?php
include '../includes/db.php';

// URL থেকে ভিডিওর আইডি নিন
if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // প্রথমে ডেটাবেস থেকে ফাইলের পাথগুলো নিন
    $sql_select = "SELECT file_path, thumbnail_path FROM videos WHERE id = ?";
    $stmt = $conn->prepare($sql_select);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $video_file_path = "../" . $row['file_path'];
        $thumbnail_file_path = "../" . $row['thumbnail_path'];

        // সার্ভার থেকে ফাইলগুলো ডিলিট করুন
        if (file_exists($video_file_path)) {
            unlink($video_file_path);
        }
        if (file_exists($thumbnail_file_path)) {
            unlink($thumbnail_file_path);
        }

        // এবার ডেটাবেস থেকে রেকর্ডটি ডিলিট করুন
        $sql_delete = "DELETE FROM videos WHERE id = ?";
        $stmt_delete = $conn->prepare($sql_delete);
        $stmt_delete->bind_param("i", $id);
        
        if ($stmt_delete->execute()) {
            // সফলভাবে ডিলিট হলে আগের পৃষ্ঠায় ফিরে যান
            header("Location: manage_videos.php");
            exit();
        } else {
            echo "ডেটাবেস থেকে রেকর্ড ডিলিট করতে সমস্যা হয়েছে।";
        }
    } else {
        echo "এই আইডির কোনো ভিডিও পাওয়া যায়নি।";
    }
} else {
    echo "অবৈধ অনুরোধ।";
}

$conn->close();
?>